/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class UpdateMaterialStatsPacket
implements IThreadsafePacket {
    private static final Logger log = Util.getLogger("NetworkSync");
    protected final Map<MaterialId, Collection<IMaterialStats>> materialToStats;

    public UpdateMaterialStatsPacket(class_2540 buffer) {
        this(buffer, MaterialRegistry::getStatDecoder);
    }

    public UpdateMaterialStatsPacket(class_2540 buffer, Function<MaterialStatsId, Function<class_2540, ? extends IMaterialStats>> decoderResolver) {
        int materialCount = buffer.readInt();
        this.materialToStats = new HashMap<MaterialId, Collection<IMaterialStats>>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.method_10810());
            int statCount = buffer.readInt();
            ArrayList statList = new ArrayList();
            for (int j = 0; j < statCount; ++j) {
                this.decodeStat(buffer, decoderResolver).ifPresent(statList::add);
            }
            this.materialToStats.put(id, statList);
        }
    }

    private Optional<IMaterialStats> decodeStat(class_2540 buffer, Function<MaterialStatsId, Function<class_2540, ? extends IMaterialStats>> decoderResolver) {
        MaterialStatsId statsId = new MaterialStatsId(buffer.method_10810());
        try {
            Function<class_2540, ? extends IMaterialStats> decoder = decoderResolver.apply(statsId);
            if (decoder == null) {
                log.error("Unknown stat type {}. Are client and server in sync?", (Object)statsId);
                return Optional.empty();
            }
            return Optional.of(decoder.apply(buffer));
        }
        catch (Exception e) {
            log.error("Could not load class for deserialization of stats {}. Are client and server in sync?", (Object)statsId, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeInt(this.materialToStats.size());
        this.materialToStats.forEach((materialId, stats) -> {
            buffer.method_10812((class_2960)materialId);
            buffer.writeInt(stats.size());
            stats.forEach(stat -> this.encodeStat(buffer, (IMaterialStats)stat));
        });
    }

    private void encodeStat(class_2540 buffer, IMaterialStats stat) {
        buffer.method_10812((class_2960)stat.getIdentifier());
        stat.encode(buffer);
    }

    @Override
    public void handleThreadsafe(ISimplePacket.Context context) {
        MaterialRegistry.updateMaterialStatsFromServer(this);
    }

    public Map<MaterialId, Collection<IMaterialStats>> getMaterialToStats() {
        return this.materialToStats;
    }

    public UpdateMaterialStatsPacket(Map<MaterialId, Collection<IMaterialStats>> materialToStats) {
        this.materialToStats = materialToStats;
    }
}

